<?php
/*
Plugin Name: Auto Picture Image
Plugin URI: https://kaminarimagazine.com/web/2019/07/29/auto-picture-image/#plugin
Description: the_content()で吐き出されたimgタグの画像を自動でpictureタグで囲い、webpの設定を追加するプラグインです。
Author: Shinji Sato
Author URI: https://kaminarimagazine.com/
License: GPLv2
Version: 0.1
*/


//メイン
class auto_Picture_Image {
  const version = '0.1';
  private static $_uploadDir = null;

	public function __construct() {
    self::_init_basevars();
		add_action( 'wp_head', array( $this, 'setup' ), 10 );
	}

	public function setup() {
		add_filter( 'the_content', array( $this, 'main_func' ), 10 );
	}

  //書き換え部
	public function main_func( $content ) {
    
		if ( ! is_feed() && ! is_preview() ) {
      preg_match_all('/<img.*?src\s*=\s*[\"|\'](.*?)[\"|\'].*?>/i',$content,$images,PREG_OFFSET_CAPTURE);
      preg_match_all('/(?:<picture(?:[^>]*?)>(.*?)<\/picture>)/si',$content,$pictures,PREG_OFFSET_CAPTURE);
      if($pictures[0][0]){
        $pictures[0] = array_reverse($pictures[0]);
        $pictures[1] = array_reverse($pictures[1]);
        $pictures = array_reverse($pictures);
        $p_Count = count($pictures[1]);
      }else{
        $p_Count = 0;
      }
      foreach ($images[0] as $i => $image){
        if($p_Count){
          if(preg_match($image[0],$pictures[1][$p_Count-1][0]) && $image[1]>$pictures[1][$p_Count-1][1]){
            $webp_Url = false;
            $p_Count--;
          }else{
            $webp_Url = self::_check_Image($i,$images);
          }
        }else{
          $webp_Url = self::_check_Image($i,$images);
        }
        if($webp_Url){
          $new_Image = '<picture>';
          $new_Image .= "<source type=\"image/webp\" srcset=\"{$webp_Url}\">";
          $new_Image .= preg_replace( '/<img((?![^>]*data\-autocheck\s*=)[^>]*)>/i', '<img data-autocheck="ok"${1}>', $image[0] );
          $new_Image .= '</picture>';
          $content = preg_replace('{'.preg_quote($image[0]).'}',$new_Image,$content,1);
        }
      }
		}
		return $content;
  }

  
  
  //ファイルの存在チェック関連
  public static function _check_Image($i,$images){
    $my_option = get_option('my_option');
    if(preg_match('/^https?:\/\//i', $images[1][$i][0])){
      $my_File_Url = $images[1][$i][0];
    }else if($my_option['base_url']){
      $my_File_Url = $my_option['base_url'].'/'.$images[1][$i][0];
    }else{
      $my_File_Url = (empty($_SERVER['HTTPS']) ? 'http://' : 'https://') . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'].'/'.$images[1][$i][0];
    }
    
    if(preg_match('/^https?:\/\//i', $my_File_Url)){
      $mykey = preg_match('/\?.*/i',$my_File_Url,$url_Query);
      $my_Image_Url = $mykey ? str_replace($url_Query,'',$my_File_Url) : $my_File_Url;
      $local_Path = self::_urlToLocalPath($my_Image_Url);
      $file_Extension = strtolower(substr($local_Path, strrpos($local_Path, '.') + 1));

      if($file_Extension !== 'webp'){
        if(file_exists(substr($local_Path,0, strrpos($local_Path, '.')).'.webp')){
          
          return substr($my_Image_Url,0, strrpos($my_Image_Url, '.')).'.webp';
        }else{
          return false;
        }
      }else{
        return false;
      }
    }
  }


  /**
   * 画像URLをローカルパスに変換
   * @param $url
   * @return string
   */
  private static function _urlToLocalPath($url){
    
    $localPath = str_replace(self::$_uploadDir['baseurl'], self::$_uploadDir['basedir'], $url);
    return $localPath;
  }

  /**
   * ローカルパスとURLを相互変換するための値を設定
   */
  private static function _init_basevars(){
    //self::$_uploadDir = wp_upload_dir();
    $protocol = parse_url(home_url(), PHP_URL_SCHEME);
    $basedir = $_SERVER['DOCUMENT_ROOT'];
    $baseurl = $protocol . '://' . $_SERVER['SERVER_NAME'];
    self::$_uploadDir = array(
      'basedir' => rtrim($basedir, '/'),
      'baseurl' => rtrim($baseurl, '/'),
    );
  }

  //手動
  /*
  * imgタグ単体を対象とした関数。imgタグ(複数可)を含む文字列の場合は"_create_Pictures"を使用してください。
  * 第一引数で設定したimgタグをpictureタグで囲い、sourceタグでwebp画像を設定して返す。
  * 第二引数でechoを与えるとreturnで返さずechoで吐き出す。
  * @param $html (string) 
  * @param $return (string) 初期値：null
  * @return string
  */
  public static function _create_Picture($html = null,$return = null){
    preg_match('/<img.*?src\s*=\s*[\"|\'](.*?)[\"|\'].*?>/i',$html,$image,PREG_OFFSET_CAPTURE);
    $webp_Url = self::_create_Picture_check($image);
    if($webp_Url){
      $new_Image = <<<EOT
      <picture>
        <source type="image/webp" srcset="{$webp_Url}">
        {$html}
      </picture>
EOT;
      if($return == 'echo'){
        echo $new_Image;
      }else{
        return $new_Image;
      }
    }else{
      if($return == 'echo'){
        echo $html;
      }else{
        return $html;
      }
    }

  }

  /*
  * imgタグ(複数可)を含む文字列を対象にした関数。imgタグ単体の場合は"_create_Picture"を推奨。
  * 第一引数で設定した文字列のimgタグをpictureタグで囲い、sourceタグでwebp画像を設定して返す。
  * 第二引数でechoを与えるとreturnで返さずechoで吐き出す。初期値：null
  * @param $html (string) 
  * @param $return (string) 
  * @return string
  */
  public static function _create_Pictures($html = null,$return = null){
    preg_match_all('/<img.*?src\s*=\s*[\"|\'](.*?)[\"|\'].*?>/i',$html,$images,PREG_OFFSET_CAPTURE);
    preg_match_all('/(?:<picture(?:[^>]*?)>(.*?)<\/picture>)/si',$html,$pictures,PREG_OFFSET_CAPTURE);
    if($pictures[0][0]){
      $pictures[0] = array_reverse($pictures[0]);
      $pictures[1] = array_reverse($pictures[1]);
      $pictures = array_reverse($pictures);
      $p_Count = count($pictures[1]);
    }else{
      $p_Count = 0;
    }
    foreach ($images[0] as $i => $image){
      if($p_Count){
        if(preg_match($image[0],$pictures[1][$p_Count-1][0]) && $image[1]>$pictures[1][$p_Count-1][1]){
          $webp_Url = false;
          $p_Count--;
        }else{
          $webp_Url = self::_check_Image($i,$images);
        }
      }else{
        $webp_Url = self::_check_Image($i,$images);
      }
      if($webp_Url){
        $new_Image = '<picture>';
        $new_Image .= "<source type=\"image/webp\" srcset=\"{$webp_Url}\">";
        $new_Image .= preg_replace( '/<img((?![^>]*data\-autocheck\s*=)[^>]*)>/i', '<img data-autocheck="ok"${1}>', $image[0] );
        $new_Image .= '</picture>';
        $html = preg_replace('{'.preg_quote($image[0]).'}',$new_Image,$html,1);
      }
    }
    if($return == 'echo'){
      echo $html;
    }else{
      return $html;
    }
  }

  public static function _create_Picture_check($image){
    $my_option = get_option('my_option');
    if(preg_match('/^https?:\/\//i', $image[1][0])){
      $my_File_Url = $image[1][0];
    }else if($my_option['base_url']){
      $my_File_Url = $my_option['base_url'].'/'.$image[1][0];
    }else{
      $my_File_Url = (empty($_SERVER['HTTPS']) ? 'http://' : 'https://') . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'].'/'.$images[1][0];
    }
    if(preg_match('/^https?:\/\//i', $my_File_Url)){
      $mykey = preg_match('/\?.*/i',$my_File_Url,$url_Query);
      $my_Image_Url = $mykey ? str_replace($url_Query,'',$my_File_Url) : $my_File_Url;
      $local_Path = self::_urlToLocalPath($my_Image_Url);
      $file_Extension = strtolower(substr($local_Path, strrpos($local_Path, '.') + 1));

      if($file_Extension !== 'webp'){
        if(file_exists(substr($local_Path,0, strrpos($local_Path, '.')).'.webp')){
          
          return substr($my_Image_Url,0, strrpos($my_Image_Url, '.')).'.webp';
        }else{
          return false;
        }
      }else{
        return false;
      }
    }
  }
 


  /**
   * 画像ローカルパスをURLに変換
   * @param $localPath
   * @return string
   */
  private static function _localPathToUrl($localPath){
    if(!self::$_uploadDir){
      self::_init_basevars();
    }
    $url = str_replace(self::$_uploadDir['basedir'], self::$_uploadDir['baseurl'], $localPath);
    return $url;
  }
}
new auto_Picture_Image();

//設定
class auto_Picture_Image_Setting {
    /**
     * Holds the values to be used in the fields callbacks
     */
    private $options;

    /**
     * Start up
     */
    public function __construct(){
        add_action( 'admin_menu', array( $this, 'add_plugin_page' ) );
        add_action( 'admin_init', array( $this, 'page_init' ) );
    }

    /**
     * Add options page
     */
    public function add_plugin_page(){
        // This page will be under "Settings"
        add_options_page(
            'Settings Admin', 
            'Auto Picture Image', 
            'manage_options', 
            'my-setting-admin', 
            array( $this, 'create_admin_page' )
        );
    }

    /**
     * Options page callback
     */
    public function create_admin_page(){
        // Set class property
        $this->options = get_option( 'my_option' );
        ?>
        <div class="wrap">
            <?php screen_icon(); ?>
            <h2>Auto Picture Image Setting</h2>           
            <form method="post" action="options.php">
            <?php
                // This prints out all hidden setting fields
                settings_fields( 'setting_group' );   
                do_settings_sections( 'my-setting-admin' );
                submit_button(); 
            ?>
            </form>
        </div>
        <?php
    }

    /**
     * Register and add settings
     */
    public function page_init(){       
        register_setting(
            'setting_group', // Option group
            'my_option', // Option name
            array( $this, 'sanitize' ) // Sanitize
        );

        add_settings_section(
            'setting_section_id', // ID
            'URLの設定', // Title
            array( $this, 'print_section_info' ), // Callback
            'my-setting-admin' // Page
        );  

        add_settings_field(
            'base_url', // ID
            'baseタグに設定しているURL', // Title 
            array( $this, 'base_url_callback' ), // Callback
            'my-setting-admin', // Page
            'setting_section_id' // Section           
        );      
    }

    /**
     * Sanitize each setting field as needed
     *
     * @param array $input Contains all settings fields as array keys
     */
    public function sanitize( $input ){
        $new_input = array();
        
        if( isset( $input['base_url'] ) )  $new_input['base_url'] = sanitize_text_field( $input['base_url'] );

        return $new_input;
    }

    /** 
     * Print the Section text
     */
    public function print_section_info(){
        print 'baseタグに設定しているURLを入力してください。<br>※空の値を入力すると表示中のページのURLが適応されます。';
    }

    /** 
     * Get the settings option array and print one of its values
     */
    public function base_url_callback(){
        $url1 = get_stylesheet_directory_uri();
        $url2 = get_template_directory_uri();
        printf(
            '<input type="text" id="base_url" name="my_option[base_url]" value="%s" />',
            isset( $this->options['base_url'] ) ? esc_attr( $this->options['base_url']) : ''
        );

        echo <<<EOT
        <dl>
          <dt>●参考</dt>
          <dt>・get_stylesheet_directory_uri()の値</dt>
          <dd>{$url1}</dd>
          <dt>・get_template_directory_uri()の値</dt>
          <dd>{$url2}</dd>
        </dl>
        <style>
        #base_url{
          width:500px;
        }
        </style>
EOT;
    }
}

if( is_admin() ) $my_settings_page = new auto_Picture_Image_Setting();